desktopify-js
============
desktopify-js is a very simple jQuery plugin aimed at making basic desktop-like environments providing reordering, selecting and drag & drop on static HTML elements, turning them into folder-like views.

As I write this readme file, the plugin is still actively being developed. It is currently nowhere near a public release, although it might be useful for some basic projects.

Installation
------------
Installation of the plugin is as simple as downloading a copy of the JS file from the `lib` folder in this repository and linking it in your HTML file. No extra stylesheets are required.

```html
<script src="desktopify.min.js"></script>
```

If the appropriate jQuery version is used, the plugin should also work in ancient browsers like IE7 (if you fancy). You may use jQuery version 1.12.4 for this purpose, which you can obtain from the [jQuery CDN](https://code.jquery.com/).

Basic usage
-----------
In its most basic form, the plugin can be used on any container element containing zero or more child elements as follows:

```javascript
$('#container').desktopify();
```

By default, the plugin assumes the `.ui-icon` class for child elements. All of these classes including other options are, ofcourse, customizeable by setting the appropriate parameters in the options object passed to the plugin, e.g.:

```javascript
$('#container').desktopify({
	iconClass: 'ui-icon',
	ghostClass: 'ui-ghost',
	selectedClass: 'ui-selected',
	selectingClass: 'ui-selecting'
});
```

For a more thorough example, please refer to the `example` directory in this repository.

Options
-------
The complete list of options with corresponding default values is displayed below. All of these are overrideable by redefining them on the `$.fn.desktopify.defaults` object before initializing any plugin instances.

```javascript
$.fn.desktopify.defaults = {
	element: '',
	exclude: '',
	iconClass: 'ui-icon',
	ghostClass: 'ui-ghost',
	selectedClass: 'ui-selected',
	selectingClass: 'ui-selecting',
	dropTargetClass: 'ui-drop-target',
	ghostContainerClass: 'ui-ghost-container',
	rectangleHtml: '<div class="ui-rectangle"/>',
	indicatorHtml: '<div class="ui-indicator"/>',
	autoScrollSpeed: 6,
	autoScrollPlay: 30,
	autoScrollGap: 5,
	ghostOffset: 10,
	reorder: true,
	onReposition: function () { },
	onBeforeDelete: function () { },
	onDelete: function () { },
	onBeforeHover: function () { return false },
	onHover: function () { },
	onBeforeMove: function () { return [] },
	onMove: function () { },
	onDragOver: function () { return false },
	onDropItems: function () { },
	onDropData: function () { }
};
```

More info coming soon...

License
-------

Copyright (c) 2020 Midas Wouters

[The MIT License](http://lauri.rooden.ee/mit-license.txt)
