"use strict";
(function ($) {
    $.topZIndex = function (selector) {
        return Math.max(0, Math.max.apply(null, $.map(((selector || "*") === "*") ? $.makeArray(document.getElementsByTagName("*")) : $(selector), function (v) {
            return parseFloat($(v).css("z-index")) || null;
        })));
    };
    $.fn.topZIndex = function (opt) {
        if (this.length === 0) {
            return this;
        }
        opt = $.extend({ increment: 1 }, opt);
        var zmax = $.topZIndex(opt.selector), inc = opt.increment;
        return this.each(function () {
            this.style.zIndex = (zmax += inc);
        });
    };
})(jQuery);
(function ($) {
    $.desktopify = function (container, options) {
        this.settings = options;
        var _prototype = $.desktopify.prototype;
        var self = this;
        var dragStarted = false, dragging = false, selecting = false, hovering = false;
        var canDropItems = false, canDropData = false, reposition = false;
        var x1 = 0, y1 = 0, x2 = 0, y2 = 0;
        var closestLeft, closestRight, currentIndex;
        var styles = { position: 'absolute', display: 'none' };
        var indicatorHtml = options.indicatorHtml != '' ? options.indicatorHtml : '<div/>';
        var $container = $(container);
        var $element = (options.element != '' ? $(options.element) : $container).attr('tabindex', 0);
        var $rectangle = $(options.rectangleHtml).css(styles).appendTo($element);
        var $indicator = $(indicatorHtml).css(styles).appendTo($container);
        var element = $element[0];
        var $ghostContainer = $([]);
        var containerOffset;
        var scrollOffsetStartX, scrollDistanceX;
        var scrollOffsetStartY, scrollDistanceY;
        var positions = [];
        var centers = [];
        var $icons = $([]);
        function resetScrollDistance() {
            scrollOffsetStartX = container.scrollLeft;
            scrollOffsetStartY = container.scrollTop;
            scrollDistanceX = 0;
            scrollDistanceY = 0;
        }
        function updateScrollDistance() {
            scrollDistanceX = scrollOffsetStartX - container.scrollLeft;
            scrollDistanceY = scrollOffsetStartY - container.scrollTop;
        }
        function calculateRect() {
            var extraX = element == container ? container.scrollLeft : 0;
            var extraY = element == container ? container.scrollTop : 0;
            var j1 = x1 + extraX + scrollDistanceX;
            var j2 = x2 + extraX;
            var k1 = y1 + extraY + scrollDistanceY;
            var k2 = y2 + extraY;
            var offs1 = $element.offset();
            offs1.left += parseInt($element.css('border-left-width')) || 0;
            offs1.top += parseInt($element.css('border-top-width')) || 0;
            var x3 = Math.min(j1, j2) - offs1.left;
            var y3 = Math.min(k1, k2) - offs1.top;
            var x4 = Math.max(j1, j2) - offs1.left;
            var y4 = Math.max(k1, k2) - offs1.top;
            var b_x3 = Math.max(x3, 0);
            var b_y3 = Math.max(y3, 0);
            var b_x4 = Math.min(x4, Math.max($element.width(), element.scrollWidth - element.scrollLeft + extraX));
            var b_y4 = Math.min(y4, Math.max($element.height(), element.scrollHeight - element.scrollTop + extraY));
            $rectangle.css({
                left: b_x3 + 'px',
                top: b_y3 + 'px',
                width: b_x4 - b_x3 - (parseInt($rectangle.css('border-left-width')) || 0) * 2 + 'px',
                height: b_y4 - b_y3 - (parseInt($rectangle.css('border-top-width')) || 0) * 2 + 'px'
            });
            var offs2 = {
                left: containerOffset.left + (parseInt($container.css('border-left-width')) || 0) + extraX - offs1.left - container.scrollLeft,
                top: containerOffset.top + (parseInt($container.css('border-top-width')) || 0) + extraY - offs1.top - container.scrollTop
            };
            $icons.each(function (i, el) {
                var center = {
                    x: centers[i].left + offs2.left,
                    y: centers[i].top + offs2.top
                };
                if (center.y > y3 && center.y < y4 && center.x > x3 && center.x < x4)
                    $(el).addClass(options.selectingClass);
                else
                    $(el).removeClass(options.selectingClass);
            });
        }
        function destroyGhosts() {
            $ghostContainer.remove();
        }
        function createGhosts() {
            $ghostContainer = $('<div/>').addClass(options.ghostContainerClass).appendTo($('body'));
            var minX = null, maxX = null, minY = null, maxY = null;
            var $items = $(_prototype.dragData);
            $items.each(function (i, el) {
                var $el = $(el);
                var pos = $el.position();
                minX = minX != null ? Math.min(minX, pos.left) : pos.left;
                maxX = maxX != null ? Math.max(maxX, pos.left + $el.outerWidth(true)) : pos.left + $el.outerWidth(true);
                minY = minY != null ? Math.min(minY, pos.top) : pos.top;
                maxY = maxY != null ? Math.max(maxY, pos.top + $el.outerHeight(true)) : pos.top + $el.outerHeight(true);
            });
            $items.each(function (i, el) {
                var $el = $(el);
                var pos = $el.position();
                $el.clone()
                    .removeClass(options.selectedClass)
                    .addClass(options.ghostClass)
                    .css({
                    'left': pos.left - minX + 'px',
                    'top': pos.top - minY + 'px',
                    'position': 'absolute',
                    'cursor': 'default'
                })
                    .appendTo($ghostContainer);
            });
            $ghostContainer.css({
                'pointer-events': 'none',
                'z-index': $.topZIndex(),
                'position': 'absolute',
                'overflow': 'hidden',
                'display': 'none'
            });
            if (_prototype.supportsPointerEvents) {
                var offs = {
                    left: containerOffset.left + (parseInt($container.css('border-left-width')) || 0),
                    top: containerOffset.top + (parseInt($container.css('border-top-width')) || 0)
                };
                $ghostContainer.data('bounds', {
                    left: minX + offs.left,
                    top: minY + offs.top,
                    right: maxX + offs.left,
                    bottom: maxY + offs.top
                });
            }
            else {
                $ghostContainer.data('bounds', {
                    left: x1 + options.ghostOffset,
                    top: y1 + options.ghostOffset,
                    right: x1 + options.ghostOffset + (maxX - minX),
                    bottom: y1 + options.ghostOffset + (maxY - minY)
                });
            }
        }
        this.update = function (full) {
            if (typeof full === 'undefined')
                full = true;
            $indicator.hide();
            var $icons_prev = $icons;
            $icons = $container.find('.' + options.iconClass);
            if (!full) {
                full = $icons.length != $icons_prev.length;
                if (!full) {
                    for (var i = 0, n = $icons.length; i < n; ++i) {
                        if ($icons[i] !== $icons_prev[i]) {
                            full = true;
                            break;
                        }
                    }
                }
            }
            if (full) {
                $icons.each(function (i, el) {
                    var $el = $(el);
                    var pos = $el.position();
                    positions[i] = {
                        top: pos.top + container.scrollTop,
                        left: pos.left + container.scrollLeft
                    };
                    centers[i] = {
                        top: positions[i].top + $el.outerHeight(true) / 2,
                        left: positions[i].left + $el.outerWidth(true) / 2
                    };
                });
                containerOffset = $container.offset();
            }
        };
        this.init = function () {
            self.update();
            resetScrollDistance();
            $container.scroll(function (e) {
                if (selecting) {
                    updateScrollDistance();
                    calculateRect();
                }
            });
            $(window).resize(function () {
                self.update();
            });
            if (options.exclude != '') {
                $element.on('mousedown touchstart', options.exclude, function (e) {
                    e.stopPropagation();
                });
            }
            $container.on('mouseenter', '.' + options.iconClass, function (e) {
                $icons.removeClass(options.dropTargetClass);
                canDropItems = _prototype.dragData.length != 0
                    && $.inArray(this, _prototype.dragData) == -1
                    && options.onBeforeHover(this, _prototype.dragData) == true;
                if (_prototype.dragging && canDropItems) {
                    $(this).addClass(options.dropTargetClass);
                    hovering = true;
                    options.onHover(this, _prototype.dragData);
                }
            });
            $container.on('mouseleave', '.' + options.iconClass, function (e) {
                hovering = false;
                if (_prototype.supportsPointerEvents) {
                    $(this).removeClass(options.dropTargetClass);
                }
            });
            $container.on('mouseup', '.' + options.iconClass, function (e) {
                $icons.removeClass(options.dropTargetClass);
                if ($.inArray(this, _prototype.dragData) != -1)
                    canDropItems = false;
                if (_prototype.dragging && canDropItems) {
                    options.onDropItems(this, _prototype.dragData);
                    _prototype.dragData = [];
                    self.update();
                }
            });
            $container.on('mousedown touchstart', '.' + options.iconClass, function (e) {
                self.update();
                x1 = x2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
                y1 = y2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;
                if (!$(e.currentTarget).hasClass(options.selectedClass)) {
                    if (!e.ctrlKey)
                        $icons.removeClass(options.selectedClass);
                    $(e.currentTarget).addClass(options.selectedClass);
                }
                else if (e.ctrlKey) {
                    $(e.currentTarget).toggleClass(options.selectedClass);
                }
                currentIndex = $.inArray(e.currentTarget, $icons.toArray());
                _prototype.dragging = dragging = true;
                _prototype.dragData = $icons.filter('.' + options.selectedClass).toArray();
                _prototype.dragDataSource = $container;
                createGhosts();
                resetScrollDistance();
                e.stopPropagation();
                e.preventDefault();
            });
            $container.on('click', '.' + options.iconClass, function (e) {
                if (e.ctrlKey && $icons.filter('.' + options.selectedClass).length >= 2)
                    e.preventDefault();
            });
            function dragFunc() {
                var offs_x2 = x2 - containerOffset.left + container.scrollLeft;
                var offs_y2 = y2 - containerOffset.top + container.scrollTop;
                var distances = [];
                var closestY = 0;
                self.update(false);
                for (var i = 0, n = $icons.length; i < n; ++i) {
                    distances[i] = {
                        x: centers[i].left - offs_x2,
                        y: centers[i].top - offs_y2
                    };
                    if (Math.abs(distances[i].y) < Math.abs(distances[closestY].y))
                        closestY = i;
                }
                var $el = $icons.eq(closestY);
                var minY = positions[closestY].top;
                var maxY = minY + $el.height();
                var indY = minY;
                var indH = $el.outerHeight();
                var noMatchRow = [];
                var leftX = null, rightX = null;
                for (var i = 0, n = distances.length; i < n; ++i) {
                    noMatchRow[i] = (centers[i].top < minY || centers[i].top > maxY);
                    if (noMatchRow[i])
                        continue;
                    indY = Math.min(indY, positions[i].top);
                    indH = Math.max(indH, $icons.eq(i).outerHeight());
                    if (distances[i].x < 0)
                        leftX = leftX != null ? Math.max(distances[i].x, leftX) : distances[i].x;
                    else
                        rightX = rightX != null ? Math.min(distances[i].x, rightX) : distances[i].x;
                }
                closestLeft = closestRight = -1;
                for (var i = 0, n = distances.length; i < n; ++i) {
                    if (noMatchRow[i])
                        continue;
                    if (distances[i].x == leftX)
                        closestLeft = i;
                    else if (distances[i].x == rightX)
                        closestRight = i;
                    if (closestLeft != -1 && closestRight != -1)
                        break;
                }
                if ((currentIndex != closestLeft && currentIndex != closestRight) || !dragging) {
                    reposition = true;
                    var $el1 = $icons.eq(closestLeft);
                    var $el2 = $icons.eq(closestRight);
                    var pos1 = positions[closestLeft];
                    var pos2 = positions[closestRight];
                    var center = void 0;
                    if (closestLeft == -1)
                        center = pos2.left + (parseInt($el2.css('margin-left')) || 0);
                    else if (closestRight == -1)
                        center = pos1.left + $el1.outerWidth(true) - (parseInt($el1.css('margin-right')) || 0);
                    else
                        center = (pos1.left + pos2.left + $el2.outerWidth(true)) / 2;
                    $indicator.css({
                        left: center - $indicator.width() / 2 + 'px',
                        top: indY + 'px',
                        height: indH + 'px',
                        'margin-top': $el1.css('margin-top')
                    });
                    if (options.indicatorHtml != '')
                        $indicator.show();
                }
                else {
                    reposition = false;
                    $indicator.hide();
                }
            }
            var counter = 0;
            $element.on('dragenter', function (e) {
                counter++;
            });
            $element.on('dragleave', function (e) {
                counter--;
                if (counter == 0) {
                    _prototype.currentElement = null;
                    $indicator.hide();
                }
            });
            $element.on('dragover', function (e) {
                if (!_prototype.stopBubble && _prototype.currentElement != this) {
                    _prototype.currentElement = this;
                    self.update();
                }
                _prototype.stopBubble = true;
                x2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
                y2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;
                if (_prototype.currentElement == this)
                    console.log(y2 - containerOffset.top);
                canDropData = options.onDragOver.call(container, e.originalEvent.dataTransfer) == true;
                if (options.reorder && canDropData && $icons.length && _prototype.currentElement == this)
                    dragFunc();
                else
                    $indicator.hide();
                e.preventDefault();
            });
            $(document).on('dragover', function (e) {
                _prototype.stopBubble = false;
            });
            $element.on('drop', function (e) {
                if (canDropData) {
                    var data = e.originalEvent.dataTransfer;
                    options.onDropData.call(container, data);
                    canDropData = false;
                }
                counter = 0;
                $indicator.hide();
                e.preventDefault();
                e.stopPropagation();
            });
            $element.on('mousedown touchstart', function (e) {
                self.update();
                $icons.removeClass(options.dropTargetClass);
                x1 = x2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
                y1 = y2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;
                $element.focus();
                if (!e.ctrlKey)
                    $icons.removeClass(options.selectedClass);
                selecting = true;
                resetScrollDistance();
                calculateRect();
                $rectangle.show();
                e.preventDefault();
                e.stopPropagation();
            });
            $element.on('mouseleave', function (e) {
                $indicator.hide();
                reposition = false;
                _prototype.currentElement = null;
            });
            $element.on('mousemove touchmove', function (e) {
                if (!_prototype.stopBubble && _prototype.currentElement != this) {
                    _prototype.currentElement = this;
                    self.update();
                }
                _prototype.stopBubble = true;
                if (_prototype.dragging) {
                    if (hovering || _prototype.currentElement != element) {
                        $indicator.hide();
                        reposition = false;
                    }
                    else if (options.reorder && $icons.length) {
                        dragFunc();
                    }
                }
            });
            var maxSpeed = options.autoScrollSpeed;
            var play = options.autoScrollPlay;
            var gap = options.autoScrollGap;
            var timeout1 = null;
            var timeout2 = null;
            var speedY = 0;
            var speedX = 0;
            $container.on('mouseleave mousedown wheel DOMMouseScroll mousewheel keyup touchmove', function () {
                if (_prototype.dragging)
                    clearTimeout(timeout1), clearTimeout(timeout2);
            });
            function stepUp() {
                if ((_prototype.dragging || selecting) && container.scrollTop > 0) {
                    container.scrollTop -= Math.ceil(speedY);
                    timeout1 = setTimeout(stepUp, 50 * (maxSpeed - speedY) / maxSpeed);
                }
            }
            function stepDown() {
                if ((_prototype.dragging || selecting) && container.scrollTop < container.scrollHeight - $container.innerHeight()) {
                    container.scrollTop += Math.ceil(speedY);
                    timeout1 = setTimeout(stepDown, 50 * (maxSpeed - speedY) / maxSpeed);
                }
            }
            function stepLeft() {
                if ((_prototype.dragging || selecting) && container.scrollLeft > 0) {
                    container.scrollLeft -= Math.ceil(speedX);
                    timeout2 = setTimeout(stepLeft, 50 * (maxSpeed - speedX) / maxSpeed);
                }
            }
            function stepRight() {
                if ((_prototype.dragging || selecting) && container.scrollLeft < container.scrollWidth - $container.innerWidth()) {
                    container.scrollLeft += Math.ceil(speedX);
                    timeout2 = setTimeout(stepRight, 50 * (maxSpeed - speedX) / maxSpeed);
                }
            }
            function calcSpeed1(distance) {
                return Math.min(1, distance / (play - gap)) * maxSpeed;
            }
            function calcSpeed2(distance) {
                return Math.min(1, distance / play) * maxSpeed;
            }
            $container.on('mousemove touchmove', function (e) {
                if (_prototype.dragging) {
                    clearTimeout(timeout1), clearTimeout(timeout2);
                    if (y2 < containerOffset.top + play) {
                        speedY = calcSpeed1(play - (y2 - containerOffset.top));
                        stepUp();
                    }
                    else if (y2 > containerOffset.top + $container.innerHeight() - play) {
                        speedY = calcSpeed1(y2 - (containerOffset.top + $container.innerHeight() - play));
                        stepDown();
                    }
                    if (x2 < containerOffset.left + play) {
                        speedX = calcSpeed1(play - (x2 - containerOffset.left));
                        stepLeft();
                    }
                    else if (x2 > containerOffset.left + $container.innerWidth() - play) {
                        speedX = calcSpeed1(x2 - (containerOffset.left + $container.innerWidth() - play));
                        stepRight();
                    }
                }
            });
            $(document).on('mousemove touchmove', function (e) {
                _prototype.stopBubble = false;
                x2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
                y2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;
                if (selecting) {
                    calculateRect();
                    clearTimeout(timeout1), clearTimeout(timeout2);
                    if (y2 < containerOffset.top + (parseInt($container.css('border-top-width')) || 0)) {
                        speedY = calcSpeed2((containerOffset.top + (parseInt($container.css('border-top-width')) || 0)) - y2);
                        stepUp();
                    }
                    else if (y2 > (containerOffset.top + $container.outerHeight() - 1)) {
                        speedY = calcSpeed2(y2 - (containerOffset.top + $container.outerHeight() - 1));
                        stepDown();
                    }
                    if (x2 < containerOffset.left + (parseInt($container.css('border-left-width')) || 0)) {
                        speedX = calcSpeed2((containerOffset.left + (parseInt($container.css('border-left-width')) || 0)) - x2);
                        stepLeft();
                    }
                    else if (x2 > (containerOffset.left + $container.outerWidth() - 1)) {
                        speedX = calcSpeed2(x2 - (containerOffset.left + $container.outerWidth() - 1));
                        stepRight();
                    }
                }
                else if (_prototype.dragging) {
                    if (dragging) {
                        if (!dragStarted) {
                            dragStarted = true;
                            $ghostContainer.show();
                        }
                        var mouseOffsetX = x2 - x1;
                        var mouseOffsetY = y2 - y1;
                        var bounds = $ghostContainer.data('bounds');
                        bounds = {
                            left: bounds.left + mouseOffsetX,
                            top: bounds.top + mouseOffsetY,
                            right: Math.min(bounds.right + mouseOffsetX, $(document).width()),
                            bottom: Math.min(bounds.bottom + mouseOffsetY, $(document).height())
                        };
                        $ghostContainer.css({
                            left: bounds.left + 'px',
                            top: bounds.top + 'px',
                            width: bounds.right - bounds.left + 'px',
                            height: bounds.bottom - bounds.top + 'px'
                        });
                    }
                }
                if (e.type != 'touchmove')
                    e.preventDefault();
            });
            $element.on('mouseup touchend', function (e) {
                if (_prototype.dragging) {
                    _prototype.dragging = dragging = false;
                    if (!hovering && _prototype.dragData.length) {
                        var $items = $(_prototype.dragData);
                        var scrollTop = container.scrollTop;
                        var scrollLeft = container.scrollLeft;
                        if (_prototype.dragDataSource != $container) {
                            $items = $(options.onBeforeMove.call(container, _prototype.dragData));
                            if ($items.length) {
                                if (!options.reorder || !$icons.length)
                                    $items.appendTo($container);
                                else if (closestRight == -1)
                                    $items.insertAfter($icons.eq(closestLeft));
                                else
                                    $items.insertBefore($icons.eq(closestRight));
                                options.onMove.call(container, _prototype.dragData);
                            }
                        }
                        else {
                            if (!reposition)
                                return;
                            reposition = false;
                            var offset = (closestLeft != -1 ? (closestLeft + 1) : (closestRight)) - currentIndex;
                            if (offset > 0)
                                offset--;
                            if (offset == 0)
                                return;
                            var sequential = true;
                            var icons = $icons.toArray();
                            var j = $.inArray($items[0], icons) + 1;
                            var n = $items.length;
                            for (var i = 1; i < n; ++i, ++j) {
                                if (j != $.inArray($items[i], icons)) {
                                    sequential = false;
                                    break;
                                }
                            }
                            if (sequential && Math.abs(offset) < $items.length) {
                                var $dropTarget = void 0;
                                if (offset > 0) {
                                    $dropTarget = $items.last();
                                    for (var i = 0; i <= offset; ++i) {
                                        $dropTarget = $dropTarget.next();
                                        if (!$dropTarget.length)
                                            return;
                                    }
                                }
                                else {
                                    $dropTarget = $items.first();
                                    for (var i = 0; i > offset; --i) {
                                        $dropTarget = $dropTarget.prev();
                                        if (!$dropTarget.length)
                                            return;
                                    }
                                }
                                $items.insertBefore($dropTarget);
                            }
                            else {
                                if (closestRight == -1)
                                    $items.insertAfter($icons.eq(closestLeft));
                                else
                                    $items.insertBefore($icons.eq(closestRight));
                            }
                            options.onReposition($items.toArray());
                        }
                        container.scrollTop = scrollTop;
                        container.scrollLeft = scrollLeft;
                        self.update();
                    }
                }
            });
            $(document).on('mouseup touchend', function (e) {
                _prototype.dragging = dragging = false;
                dragStarted = false;
                canDropItems = false;
                $rectangle.hide();
                $indicator.hide();
                destroyGhosts();
                if (selecting) {
                    selecting = false;
                    $icons.filter('.' + options.selectingClass)
                        .addClass(options.selectedClass)
                        .removeClass(options.selectingClass);
                }
            });
            function deleteCallback(items) {
                if (items.length) {
                    $(items).remove();
                    options.onDelete(items);
                    self.update();
                }
            }
            $element.keydown(function (e) {
                switch (e.which) {
                    case 27:
                        if (selecting) {
                            selecting = false;
                            $icons.removeClass(options.selectedClass);
                        }
                        if (dragging) {
                            _prototype.dragging = dragging = false;
                            dragStarted = false;
                            destroyGhosts();
                        }
                        $rectangle.hide();
                        $indicator.hide();
                        break;
                    case 46:
                        var arr = $icons.filter('.' + options.selectedClass).toArray();
                        if (arr.length) {
                            options.onBeforeDelete(arr, deleteCallback);
                        }
                        break;
                    case 65:
                        if (e.ctrlKey) {
                            $icons.addClass(options.selectedClass);
                            e.preventDefault();
                        }
                        break;
                }
                e.stopPropagation();
            });
        };
        this.init();
    };
    var msie = document.documentMode;
    $.desktopify.prototype.dragging = false;
    $.desktopify.prototype.dragData = [];
    $.desktopify.prototype.dragDataSource = $([]);
    $.desktopify.prototype.stopBubble = false;
    $.desktopify.prototype.currentElement = null;
    $.desktopify.prototype.supportsPointerEvents = (msie && msie <= 10) ? false : ('pointer-events' in document.body.style);
    console.log('pointer-events:', $.desktopify.prototype.supportsPointerEvents);
    $.fn.desktopify = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('desktopify')) {
                var opts = $.extend({}, $.fn.desktopify.defaults, options);
                var plugin = new $.desktopify(this, opts);
                $(this).data('desktopify', plugin);
            }
        });
    };
    $.fn.desktopify.defaults = {
        element: '',
        exclude: '',
        iconClass: 'ui-icon',
        ghostClass: 'ui-ghost',
        selectedClass: 'ui-selected',
        selectingClass: 'ui-selecting',
        dropTargetClass: 'ui-drop-target',
        ghostContainerClass: 'ui-ghost-container',
        rectangleHtml: '<div class="ui-rectangle"/>',
        indicatorHtml: '<div class="ui-indicator"/>',
        autoScrollSpeed: 6,
        autoScrollPlay: 30,
        autoScrollGap: 5,
        ghostOffset: 10,
        reorder: true,
        onReposition: function () { },
        onBeforeDelete: function () { },
        onDelete: function () { },
        onBeforeHover: function () { return false; },
        onHover: function () { },
        onBeforeMove: function () { return []; },
        onMove: function () { },
        onDragOver: function () { return false; },
        onDropItems: function () { },
        onDropData: function () { }
    };
})(jQuery);
