"use strict";

(function ($) {

	$.draggable = function (element, options) {

			const defaults = {
					handle: ''
			}

			const plugin = this;
			plugin.settings = {}

			var $element = $(element),
					element = element;

			plugin.init = function () {
					plugin.settings = $.extend({}, defaults, options);

					let $handle = $(plugin.settings.handle, $element)
					let dragging = false;

					let x1, x2, y1, y2;
					let startpos;

					$element.on('mousedown touchstart', function (e) {
						$element.css('z-index', $.topZIndex() + 1);
						e.stopPropagation();
					});

					$handle.on('mousedown touchstart', function (e) {

						x1 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
						y1 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;

						dragging = true;

						startpos = $element.position();

						//e.stopPropagation();
						e.preventDefault();
					});

					$(document).on('mousemove touchmove', function (e) {

						if (!dragging) return;

						x2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageX : e.pageX;
						y2 = e.originalEvent.touches ? e.originalEvent.touches[0].pageY : e.pageY;

						$element.css({
							left: startpos.left + (x2 - x1) + 'px',
							top: startpos.top + (y2 - y1) + 'px'
						});
					});

					$(document).on('mouseup touchend', function (e) {

						if (!dragging) return;

						dragging = false;

						if ($handle.offset().top < 0) {
							$element.css({
								top: 0 + 'px'
							});
						}
					});
			}

			plugin.init();
	}

	$.fn.draggable = function (options) {
			return this.each(function () {
					if (undefined == $(this).data('draggable')) {
							var plugin = new $.draggable(this, options);
							$(this).data('draggable', plugin);
					}
			});
	}
})(jQuery);
