/*
 * getStyleObject Plugin for jQuery JavaScript Library
 * From: http://upshots.org/?p=112
 *
 * Copyright: Unknown, see source link
 * Plugin version by Dakota Schneider (http://hackthetruth.org)
 */

(function ($) {
	$.fn.getStyleObject = function () {
		var dom = this.get(0);
		var style;
		var returns = {};
		if (window.getComputedStyle) {
			var camelize = function (a, b) {
				return b.toUpperCase();
			}
			style = window.getComputedStyle(dom, null);
			for (var i = 0; i < style.length; i++) {
				var prop = style[i];
				var camel = prop.replace(/\-([a-z])/g, camelize);
				var val = style.getPropertyValue(prop);
				returns[camel] = val;
			}
			return returns;
		}
		if (dom.currentStyle) {
			style = dom.currentStyle;
			for (var prop in style) {
				returns[prop] = style[prop];
			}
			return returns;
		}
		return this.css();
	}

	$.fn.cloneWithCSS = function () {
		var styles = {};

		var $this = $(this);
		var $clone = $this.clone();
		
		$clone.css($this.getStyleObject());

		var children = $this.children().toArray();
		var i = 0;
		while (children.length) {
			var $child = $(children.pop());
			styles[i++] = $child.getStyleObject();
			$child.children().each(function (i, el) {
				children.push(el);
			})
		}

		var cloneChildren = $clone.children().toArray()
		var i = 0;
		while (cloneChildren.length) {
			var $child = $(cloneChildren.pop());
			$child.css(styles[i++]);
			$child.children().each(function (i, el) {
				cloneChildren.push(el);
			})
		}

		return $clone
	}

})(jQuery);
