# jQuery.ddMap

Библиотека jQuery, позволяющая подключить и использовать интерактивную карту на странице простым способом.

Сейчас работает только с Яндекс Картами, но в будущем, вероятно, добавим также Google Maps и OpenStreetMap.

Фичи:
* Можно не думать о подключении скрипта Яндекс Карт, библиотека сделает это автоматически.
* Вам даже не нужно беспокоиться о размере контейнера, библиотека поставит размер по умолчанию, если он нулевой.
* Если используется более одного маркера, карта будет автоматически масштабироваться, чтобы все маркеры были видны.
* Размер карты будет автоматически обновляться при каждом срабатывании события `resize` на главном контейнере.


## Использует

* [jQuery](https://jquery.com/) >= 3.5.0 (не тестировался с более ранними версиями)
* [JS API Яндекс Карт](https://yandex.ru/dev/maps/jsapi/doc/2.1/) >= 2.1 (подключится автоматически, если отсутствует на странице)


## Usage


### 1. Подключаем JS на странице

```html
<!-- Необходимые библиотеки -->
<script src="jQuery-3.5.0.min.js"></script>

<!-- jQuery.ddMap -->
<script src="jQuery.ddMap-2.1.0.min.js"></script>
```

Можно не думать о подключении скрипта Яндекс Карт, библиотека сделает это автоматически.


### 2. Добавляем контейнер карты в любое удобное место на странице

```html
<body>
	<div class="map"></div>
</body>
```

Вам даже не нужно беспокоиться о размере контейнера, библиотека поставит размер по умолчанию, если он нулевой.


### 3. Запускаем `jQuery.fn.ddMap`

```js
$('.map').ddMap({
	//Маркеров на карту можно добавить несколько
	markers: [
		//Как минимум один обязателен
		{
			//Координаты обязательны
			latLng: [
				51.532098,
				-0.178100
			],
			//Контент опционален, можно опустить
			content: '<p>Some marker text.</p>'
		}
	]
});
```

Вот и всё!


## Описание параметров


### `jQuery.fn.ddMap(params)`

* `params`
	* Описание: Параметры.
	* Допустимые значения: `objectPlain`
	* **Обязателен**
	
* `params.markers`
	* Описание: Массив маркеров для размещения на карте.
		* Если задать несколько маркеров, карта будет автоматически смаштабирована, чтобы они все были видны.
		* Кроме того, вместо массива маркеров по-прежнему можно передавать простую пару координат (как это было в 1.2 и более ранних версиях).
	* Допустимые значения: `array`
	* **Обязателен**
	
* `params.markers[i]`
	* Описание: Данные маркера.
	* Допустимые значения: `objectPlain`
	* **Обязателен**
	
* `params.markers[i].latLng`
	* Описание: Координаты маркера (широта и долгота).
	* Допустимые значения: `array`
	* **Обязателен**
	
* `params.markers[i].content`
	* Описание: Содержимое всплывающего окна маркера. HTML-теги поддерживаются.
	* Допустимые значения: `string`
	* Значение по умолчанию: `''`
	
* `params.markers[i].icon`
	* Описание: Кастомная иконка маркера.
	* Допустимые значения: `objectPlain`
	* Значение по умолчанию: — (дефолтная иконка)
	
* `params.markers[i].icon.src`
	* Описание: Адрес изображения.
	* Допустимые значения: `string`
	* **Обязателен**
	
* `params.markers[i].icon.size`
	* Описание: Размер изображения.
	* Допустимые значения: `objectPlain`
	* **Обязателен**
	
* `params.markers[i].icon.size.width`
	* Описание: Ширина в px.
	* Допустимые значения: `integer`
	* **Обязателен**
	
* `params.markers[i].icon.size.height`
	* Описание: Высота px.
	* Допустимые значения: `integer`
	* **Обязателен**
	
* `params.apiKey`
	* Описание: API-ключ Яндекс Карт.  
		_Пока что работает и без ключа, но Яндекс декларирует его обязательным, так что рекомендуется использовать._
	* Допустимые значения: `string`
	* Значение по умолчанию: —
	
* `params.defaultZoom`
	* Описание: Дефолтный масштаб карты.
	* Допустимые значения: `integer`
	* Значение по умолчанию: `15`
	
* `params.defaultType`
	* Описание: Дефолтный тип карты.
	* Допустимые значения:
		* `'map'` — схема
		* `'satellite'` — спутник
		* `'hybrid'` — гибрид
	* Значение по умолчанию: `'map'`
	
* `params.scrollZoom`
	* Описание: Разрешить масштабирование колесом мыши?
	* Допустимые значения: `boolean`
	* Значение по умолчанию: `false`
	
* `params.mapCenterOffset`
	* Описание: Смещение центра карты относительно центра контейнера карты в пикселях.
	* Допустимые значения: `array`
	* Значение по умолчанию: `[0, 0]`
	
* `params.markerOptions`
	* Описание: Опции маркеров.
	* Допустимые значения: `objectPlain`
	* Значение по умолчанию: `{}`
	
* `params.controls`
	* Описание: Массив контролов карты.
	* Допустимые значения: `array`
	* Значение по умолчанию: `[{name: 'zoomControl'},{name: 'typeSelector'},{name: 'fullscreenControl'},{name: 'geolocationControl'},{name: 'rulerControl'}]`
	
* `params.mapOptions`
	* Описание: Опции, которые будут переданы в конструктор Яндекс карты.
	* Допустимые значения: `objectPlain`
	* Значение по умолчанию: `{suppressMapOpenBlock: true}`


## Описание событий

Все события срабатывают на основном элементе, к которому был применен `jQuery.fn.ddMap`.

* `ddBeforeInit` — Перед инициализацией (когда API карты готов, непосредственно перед вызовом конструктора карты).
* `ddAfterInit` — После инициализации.


## Ссылки

* [Home page](https://code.divandesign.ru/jquery/ddmap)
* [Telegram chat](https://t.me/dd_code)
* [GitHub](https://github.com/DivanDesign/jQuery.ddMap)


<link rel="stylesheet" type="text/css" href="https://raw.githack.com/DivanDesign/CSS.ddMarkdown/master/style.min.css" />